% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{write.design}
\alias{write.design}
\alias{write.design.csv}
\alias{write.design.xlsx}
\alias{write.design.json}
\title{Write Design Files}
\usage{
write.design(
  design,
  group_by = NULL,
  order_by = NULL,
  randomize = FALSE,
  run_files = paste0("run", ifelse(length(group_by) > 0L, paste0("_", group_by, "-\%",
    seq_along(group_by), "$s", collapse = ""), "")),
  code_files = "codes_\%s",
  output_dir,
  output_handler,
  file_extension = NULL,
  ...
)

write.design.csv(..., quote = FALSE, row.names = FALSE)

write.design.xlsx(..., format_headers = FALSE)

write.design.json(..., dataframe = "columns")
}
\arguments{
\item{design}{The \code{factorDesign} to be written into files.}

\item{group_by}{Experimental codes are to be grouped by these factors. If \code{NULL}, all codes are written into one file. Also see \code{\link[designr]{output.design}} for grouping design output.}

\item{order_by}{The experimental codes are to be ordered by these columns. Also see \code{\link[designr]{output.design}} for ordering design output.}

\item{randomize}{After ordering, lines in the same order rank are to be shuffled randomly if set to \code{TRUE}.}

\item{run_files}{The pattern to be used for the file names of the run_files (i.e., files containing the experimental codes). By default, file names are \code{"run_Group1_Othergroup4.ext"} ect.}

\item{code_files}{Code files (files containing conditions for levels of random factors) are named after this pattern.}

\item{output_dir}{All files are written into this directory.}

\item{output_handler}{This is the function that is called to write the data frames. If using \code{write.design.csv}, this is \code{utils::write.csv} and if using \code{write.design.json}, this is \code{jsonlite::write_json}.}

\item{file_extension}{This is the file_extension to be added after each file name. Use '' if no file_extension is to be added. If `NULL`, the file_extension is guessed from the output_handler used.}

\item{...}{Other parameters to be passed on to \code{write.design} and the underlying output_handler.}

\item{quote, row.names}{see \code{\link[utils:write.csv]{utils::write.csv()}}}

\item{format_headers}{see \code{\link[writexl:write_xlsx]{writexl::write_xlsx()}}, default is \code{FALSE}}

\item{dataframe}{see \code{\link[jsonlite:write_json]{jsonlite::write_json()}}}
}
\description{
This function writes a design into a set of files. For each random factor, a unit list is created that contains a list of all levels (instances) of the random factor and the factor levels to which that level is assigned. Moreover, code_files are created that contain a complete set of experimental codes.
}
\section{Functions}{
\itemize{
\item \code{write.design.csv}: Using default settings for writing CSV files

\item \code{write.design.xlsx}: Using default settings for writing XLSX files (using the \code{writexl} package)

\item \code{write.design.json}: Using default settings for writing JSON files (using the \code{jsonlite} package)
}}

\examples{

des <- fixed.factor("Factor1", c("1A","1B")) +
       fixed.factor("Factor2", c("2A","2B")) +
       random.factor("Subject", c("Factor1"))
    
# This writes a CSV file for each subject and a CSV list of subjects
write.design(des, group_by = "Subject", output_handler = write.csv, output_dir = tempdir())

# This writes a single CSV file for all subjects and a CSV list of subjects
write.design(des, output_handler = write.csv, output_dir = tempdir())

}
\seealso{
\code{\link[designr]{output.design}} for use of \code{order_by} and \code{group_by}.
}
