% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/build-github-devtools.r
\name{build_github_devtools}
\alias{build_github_devtools}
\title{Build the development version of devtools from GitHub.}
\usage{
build_github_devtools(outfile = NULL)
}
\arguments{
\item{outfile}{The name of the output file. If NULL (the default), it uses
./devtools.tgz (Mac and Linux), or ./devtools.zip (Windows).}
}
\value{
a string giving the location (including file name) of the built
 package
}
\description{
This function is especially useful for Windows users who want to upgrade
their version of devtools to the development version hosted on on GitHub.
In Windows, it's not possible to upgrade devtools while the package is loaded
because there is an open DLL, which in Windows can't be overwritten. This
function allows you to build a binary package of the development version of
devtools; then you can restart R (so that devtools isn't loaded) and install
the package.
}
\details{
Mac and Linux users don't need this function; they can use
\code{\link{install_github}} to install devtools directly, without going
through the separate build-restart-install steps.

This function requires a working development environment. On Windows, it
needs \url{http://cran.r-project.org/bin/windows/Rtools/}.
}
\examples{
\dontrun{
library(devtools)
build_github_devtools()

#### Restart R before continuing ####
install.packages("./devtools.zip", repos = NULL)

# Remove the package after installation
unlink("./devtools.zip")
}
}

