% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{DIF}
\alias{DIF}
\title{Exploratory DIF test}
\usage{
DIF(dataSrc, covariate, predicate = NULL)
}
\arguments{
\item{dataSrc}{Data source: a dexter project db handle or a data.frame}

\item{covariate}{Person covariate name for subsetting}

\item{predicate}{An optional expression to subset data, if NULL all data is used}
}
\value{
An object of class \code{DIF_stats} holding statistics for
overall-DIF and a matrix of statistics for DIF in the relative position of
item-category parameters in the regular parameterization used e.g., by OPLM.
}
\description{
Exploratory DIF test
}
\details{
Tests for DIF as described in Bechger and Maris (2014; A Statistical Test 
for Differential Item Pair Functioning. Psychometrica). Supplements the 
confirmatory approach of the profile plot
}
\examples{
\dontrun{
db = start_new_project(verbAggrRules, "verbAggression.db")
add_booklet(db, verbAggrData, "agg")
dd = DIF(db,covariate="gender")
print(dd)
plot(dd)
}

}
