% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plausible_values.R
\name{plausible_values}
\alias{plausible_values}
\title{Draw plausible values}
\usage{
plausible_values(dataSrc, parms = NULL, predicate = NULL,
  covariates = NULL, nPV = 1, use_draw = NULL)
}
\arguments{
\item{dataSrc}{Data source: a dexter project db handle or a data.frame with columns: person_id, item_id, item_score}

\item{parms}{An object returned by function \code{fit_enorm} and containing
parameter estimates. If parms is given the function provides plausible values conditional on the 
item paramaters. These are considered known. If parameter estimates are not given, the user is given 
plausible value marginalized over the posterior distribution of the item parameters. 
In plain words, this means that the uncertainty of the item parameters is taken into account.}

\item{predicate}{an expression to filter data. If missing, the function will use 
all data in dataSrc}

\item{covariates}{name or a vector of names of the variables to group the population, used to update the prior.
A covariate must be a discrete person covariate (e.g. not a float) that indicates nominal categories, e.g. gender or school
If dataSrc is a data.frame, it must contain the covariate.}

\item{nPV}{Number of plausible values to draw per person.}

\item{use_draw}{When the ENORM was fitted with a Gibbs sampler (this is 
recognised automatically), the number of the random draw (iteration) to use 
in generating the PV. If NULL, all draws will be averaged; that is, the posterior means are used for the item parameters.
If outside range, the last iteration will be used.}
}
\value{
A data.frame with columns booklet_id, person_id, sumScore and nPV plausible values
named PV1...PVn.
}
\description{
Draws plausible values based on sum scores
}
\examples{
\dontrun{
db = start_new_project(verbAggrRules, "verbAggression.db", 
   covariates=list(gender="<unknown>"))
add_booklet(db, verbAggrData, "agg")
add_item_properties(db, verbAggrProperties)
f=fit_enorm(db)
par(mfrow=c(1,2))
pv_M=plausible_values(db,f,(mode=="Do")&(gender=="Male"))
pv_F=plausible_values(db,f,(mode=="Do")&(gender=="Female"))
plot(ecdf(pv_M$PV1), 
   main="Do: males versus females", xlab="Ability", col="red")
lines(ecdf(pv_F$PV1), col="green")
legend(-2.2,0.9, c("female", "male") , 
   lty=1, col=c('green', 'red'), bty='n', cex=.75)

pv_M=plausible_values(db,f,(mode=="Want")&(gender=="Male"))
pv_F=plausible_values(db,f,(mode=="Want")&(gender=="Female"))

plot(ecdf(pv_M$PV1), 
   main="Want: males versus females", xlab=" Ability", col="red")
lines(ecdf(pv_F$PV1),col="green")
legend(-2.2,0.9, c("female", "male") , 
   lty=1, col=c('green', 'red'), bty='n', cex=.75)
   
close_project(db)    
}

}
