% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dif.R
\name{DIF}
\alias{DIF}
\title{Exploratory test for Differential Item Functioning}
\usage{
DIF(dataSrc, covariate, predicate = NULL)
}
\arguments{
\item{dataSrc}{Data source: a dexter project db handle or a data.frame with columns: person_id, item_id, item_score}

\item{covariate}{Person covariate name for subsetting}

\item{predicate}{An optional expression to subset data, if NULL all data is used}
}
\value{
An object of class \code{DIF_stats} holding statistics for
overall-DIF and a matrix of statistics for DIF in the relative position of
item-category parameters in the regular parameterization used e.g., by OPLM.
}
\description{
Exploratory test for Differential Item Functioning
}
\details{
Tests for equality of relative item difficulties category locations across groups.
Supplements the confirmatory approach of the profile plot
}
\examples{
\dontrun{
db = start_new_project(verbAggrRules, "verbAggression.db", covariates=list(gender='unknown'))
add_booklet(db, verbAggrData, "agg")
dd = DIF(db,covariate="gender")
print(dd)
plot(dd)

close_project(db)
}

}
\references{
Bechger, T. M. and Maris, G (2015); A Statistical Test for Differential Item Pair Functioning. 
Psychometrika. Vol. 80, no. 2, 317–340.
}
