% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\docType{package}
\name{dexter-package}
\alias{dexter}
\alias{dexter-package}
\title{Dexter: data analyses for educational and psychological tests.}
\description{
Dexter provides a comprehensive solution for managing and analyzing educational test data.
}
\details{
The main features are:

\itemize{
\item project databases providing a structure for storing data about persons, items, responses and booklets.
\item methods to assess data quality using Classical test theory and plots.
\item CML calibration of the extended nominal response model and interaction model.
}

To learn more about dexter, start with the vignettes: `browseVignettes(package="dexter")`  

Dexter uses the following global options
\itemize{
\item `dexter.use_tibble` return tibbles instead of data.frames, defaults to FALSE
\item `dexter.progress` show progress bars, defaults to TRUE in interactive sessions
\item `dexter.max_cores` set a maximum number of cores that dexter will use, defaults to the minimum of `Sys.getenv("OMP_THREAD_LIMIT")` and
`getOption("Ncpus")`, otherwise unlimited.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://dexter-psychometrics.github.io/dexter/}
  \item Report bugs at \url{https://github.com/dexter-psychometrics/dexter/issues}
}

}
\author{
\strong{Maintainer}: Jesse Koops \email{jesse.koops@cito.nl}

Authors:
\itemize{
  \item Gunter Maris
  \item Timo Bechger
  \item Ivailo Partchev
}

}
