% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr.R
\name{dplyr}
\alias{dplyr}
\alias{arrange.dfidx}
\alias{filter.dfidx}
\alias{slice.dfidx}
\alias{mutate.dfidx}
\alias{transmute.dfidx}
\alias{select.dfidx}
\title{Methods for dplyr verbs}
\usage{
\method{arrange}{dfidx}(.data, ...)

\method{filter}{dfidx}(.data, ...)

\method{slice}{dfidx}(.data, ...)

\method{mutate}{dfidx}(.data, ...)

\method{transmute}{dfidx}(.data, ...)

\method{select}{dfidx}(.data, ...)
}
\arguments{
\item{.data}{a dfidx object,}

\item{...}{further arguments}
}
\value{
an object of class \code{"dfidx"}
}
\description{
methods of \code{dplyr} verbs for \code{dfidx} objects.  Default functions
don't work because most of these functions returns either a
\code{tibble} or a \code{data.frame} but not a \code{dfidx}
}
\details{
These methods always return the data frame column that
contains the indexes and return a \code{dfidx} object.
}
\examples{
mn <- dfidx(munnell)
select(mn, - gsp, - water)
mutate(mn, lgsp = log(gsp), lgsp2 = lgsp ^ 2)
transmute(mn, lgsp = log(gsp), lgsp2 = lgsp ^ 2)
arrange(mn, desc(unemp), labor)
filter(mn, unemp > 10)
pull(mn, gsp)
slice(mn, c(1:2, 5:7))
}
\author{
Yves Croissant
}
