% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{id_defoliation}
\alias{id_defoliation}
\title{Identify defoliation events in a host series}
\usage{
id_defoliation(input_series, duration_years = 8, max_reduction = -1.28,
  bridge_events = FALSE, series_end_event = FALSE)
}
\arguments{
\item{input_series}{A data frame with 5 columns, as generated by \code{\link[=gsi]{gsi()}}.}

\item{duration_years}{The minimum length of time in which the tree is
considered to be in defoliation.}

\item{max_reduction}{The minimum value of \code{ngsi} required to be considered a
defoliation event. If a sequence of negative ngsi values does not reach
this threshold, the potential event is rejected. Defaults to -1.28.}

\item{bridge_events}{Binary, defaults to \code{FALSE}. This option allows for
successive events that are separated by a single year to be bridged and
become one event. It should be used cautiously and closely evaluated to
ensure the likelihood that the two (or more) events are actually one long
event.}

\item{series_end_event}{Binary, defaults to \code{FALSE}. This option allows the
user to identify an event occurring at the time of sampling as a
defoliation event, regardless of duration. Including it will help to
quantify periodicity and extent of an outbreak. This should only be used if
the user has direct knowledge of an ongoing defoliation event when the
trees were sampled.}
}
\value{
After performing runs analyses, the function adds a column to the
input data frame that distinguishes years of defoliation and the maximum
defoliation year (ie. the year the greatest negative growth departure
within the event).
}
\description{
After calculating the growth suppression index in \code{\link[=gsi]{gsi()}}, \code{\link[=id_defoliation]{id_defoliation()}}
performs a runs analysis on the normalized growth suppression index, or
\code{ngsi}, in which sequences of negative departures are assessed as possible
defoliation events. \code{\link[=id_defoliation]{id_defoliation()}} is the workhorse for
\code{\link[=defoliate_trees]{defoliate_trees()}}, performing much of the necessary criteria evaluation
used in OUTBREAK. The defaults for most parameters originate from OUTBREAK.
Two new features distinguish the \code{dfoliatR} version: bridging events that
occur in close sequence and allowing for the recent end of a series to be
evaluated for defoliation regardless of the event duration. See parameter
specifics for details.
}
\note{
\code{\link[=id_defoliation]{id_defoliation()}} is called by \code{\link[=defoliate_trees]{defoliate_trees()}}. It might only be
used by the user for troubleshooting.
}
