% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initi_py.R
\name{init_py}
\alias{init_py}
\title{'python' environment initialization}
\usage{
init_py(
  py_ver = NULL,
  dgpsi_ver = NULL,
  reinstall = FALSE,
  uninstall = FALSE,
  verb = TRUE
)
}
\arguments{
\item{py_ver}{a string that gives the 'python' version to be installed. If \code{py_ver = NULL}, the default 'python'
version '3.9.13' will be installed.}

\item{dgpsi_ver}{a string that gives the 'python' version of 'dgpsi' to be used. If \code{dgpsi_ver = NULL},
\itemize{
\item the latest 'python' version of 'dgpsi' will be used, if the package is installed from CRAN;
\item the development 'python' version of 'dgpsi' will be used, if the package is installed from GitHub.
}}

\item{reinstall}{a bool that indicates whether to reinstall the 'python' version of 'dgpsi' specified
in \code{dgpsi_ver} if it has already been installed. This argument is useful when the development version
of the R package is installed and one may want to regularly update the development 'python' version
of 'dgpsi'. Defaults to \code{FALSE}.}

\item{uninstall}{a bool that indicates whether to uninstall the 'python' version of 'dgpsi' specified
in \code{dgpsi_ver} if it has already been installed. This argument is useful when the 'python' environment
is corrupted and one wants to completely uninstall and reinstall it. Defaults to \code{FALSE}.}

\item{verb}{a bool indicating if the trace information will be printed during the function execution.
Defaults to \code{TRUE}.}
}
\value{
No return value, called to install required 'python' environment.
}
\description{
This function initializes the 'python' environment for the package.
}
\details{
See further examples and tutorials at \url{https://mingdeyu.github.io/dgpsi-R/}.
}
\examples{
\dontrun{

# See gp(), dgp(), or lgp() for an example.
}

}
