% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcn.R
\name{pcn}
\alias{pcn}
\alias{pcn_simulate}
\alias{pcn_select}
\title{Simulate and select null distributions on empirical gene-gene correlations}
\usage{
pcn_simulate(data, n.sim = 50)

pcn_select(data.sim, cl, type = c("rep", "range"), int = 5)
}
\arguments{
\item{data}{data matrix with rows as samples, columns as features}

\item{n.sim}{The number of simulated datasets to simulate}

\item{data.sim}{an object from \code{pcn_simulate}}

\item{cl}{vector of cluster memberships}

\item{type}{select either the representative dataset ("rep") or a range of
datasets ("range")}

\item{int}{every \code{int} data sets from median-ranked \code{data.sim} are
taken. Defaults to 5.}
}
\value{
\code{pcn_simulate} returns a list of length \code{n.sim}. Each
  element is a simulated matrix using this "Principal Component Normal" (pcn)
  procedure.

\code{pcn_select} returns a list with elements
\item{ranks}{When \code{type = "range"}, ranks of each extracted dataset
shown}
\item{ind}{index of representative simulation}
\item{dat}{simulation data representation of all in pcNormal}
}
\description{
Using a principal component constructed from the sample space, we simulate
null distributions with univariate Normal distributions using
\code{pcn_simulate}. Then a subset of these distributions is chosen using
\code{pcn_select}.
}
\examples{
set.seed(9)
A <- matrix(rnorm(300), nrow = 20)
pc.dat <- pcn_simulate(A, n.sim = 50)
cl <- sample(1:4, 20, replace = TRUE)
pc.select <- pcn_select(pc.dat, cl, "rep")
}
\author{
Derek Chiu
}
