% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sStateCount.r
\name{sStateCount}
\alias{sStateCount}
\title{Count states in a vector}
\usage{
sStateCount(s)
}
\arguments{
\item{s}{A character vector with elements "_", "0", "1", "2" representing
missing data, homozygots for allele 1, heterozygots, and
homozygots for allele 2. The vector should represent a single individual.}
}
\value{
Numeric vector of length 4 with counts of "_", "0", "1", "2" respectively.
}
\description{
Counts genomic states in one sample.
}
\details{
Summarizes the number of markers that are fixed for an allele in the genome of
one individual. This is used to construct the I4 matrix in \link{diem}.
}
\examples{
genotype <- c("0", "0", "_", "2", "1", "0", "1")
sStateCount(genotype)
# [1] 1 3 2 1

# calculate state counts for a polarised genotype
sStateCount(emPolarise(genotype, TRUE))
# [1] 1 1 2 3
}
\seealso{
\link{emPolarise} for changing marker polarity.
}
