% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DietTroph.R
\name{DietTroph}
\alias{DietTroph}
\title{Calculates trophic level from percentage based quantitative diet data (volumetric, weight, etc.) for species, populations, and individuals.}
\usage{
DietTroph(DietItems, PreyValues, Taxonomy, PreyClass = c("FoodI",
  "FoodII", "FoodIII", "Stage"), SumCheck = TRUE)
}
\arguments{
\item{DietItems}{A data frame with rows as individual entries and each row consisting of a prey 
classification and a corresponding diet percentages. The column names for prey classification of 
the diets should match those of PreyValues. The first column should contain the identifier of 
the individual and be named "Individual", The last column should contain the percent of the prey in the diet and be labelled "Percent".}

\item{PreyValues}{a data frame with rows as prey item names and columns containing the trophic 
level of the prey item and the standard error of that trophic item. The column names of 
PreyValues except for TL and SE should match those in DietItems.}

\item{Taxonomy}{a data frame starting with the least inclusive level progressing to more inclusive moving
towards the right.}

\item{PreyClass}{Column names of the PreyValues used for matching between DietItems and 
PreyValues, exclusive of TL and SE. Default is those of FishBase.}

\item{SumCheck}{Logical. Should the sum of diet items be checked, and, if not equal to 100, recalculated?}
}
\value{
a list length of the columns in taxonomy, each containing trophic level estimation at 
the respective taxonomic level.
}
\description{
Calculates trophic level from percentage based diet data following the routine described in TrophLab. 
While FishBase data obtained from rfishbase can be used, users can also upload their own data for
use in with function (see vignette for a tutorial).
}
\examples{
\donttest{
#Get some food item data from rfishbase
library(rfishbase)
#convert FishBase data into data for trophic calculation using dietr
converted.diet <- ConvertFishbaseDiet(ExcludeStage=NULL)
#Subset three studies out, as this contains all  studies from FishBase
my.diets <- converted.diet$DietItems[1:26,]
my.taxonomy <- converted.diet$Taxonomy[1:3,]
#Load Prey Values
data(FishBasePreyVals)
#Calculate Trophic Levels
my.TL <- DietTroph(DietItems = my.diets,PreyValues = FishBasePreyVals, Taxonomy = 
my.taxonomy, PreyClass=c("FoodI","FoodII","FoodIII","Stage"))
}
}
\author{
Samuel Borstein
}
