% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startNLR.R
\name{startNLR}
\alias{startNLR}
\title{Calculates starting values for \code{difNLR} function.}
\usage{
startNLR(Data, group, model, parameterization = "IRT")
}
\arguments{
\item{Data}{numeric: a matrix or data.frame of binary data.}

\item{group}{numeric: binary vector of group membership.
"0" for reference group, "1" for focal group.}

\item{model}{character: generalized logistic regression model
to be fitted. See \strong{Details}.}

\item{parameterization}{character: parameterization of regression
coefficients. Possible options are \code{"IRT"} (Item response theory,
default option) and \code{"LR"} (Logistic regression)}
}
\value{
A data.frame containing rows representing items and 5 columns representing parameters of \code{difNLR} model. First column represents discrimination (a), second difficulty (b), third guessing (c), fourth difference in discrimination between reference and focal group (aDif) and fifth difference in difficulty between reference and focal group (bDif).
}
\description{
Calculates starting values for \code{difNLR} function based
on linear approximation.
}
\details{
The options of \code{model} are as follows: \code{Rasch} for one-parameter logistic model with
discrimination parameter fixed on value 1 for both groups, \code{1PL} for one-parameter logistic
model with discrimination parameter fixed for both groups, \code{2PL} for logistic regression model,
\code{3PLcg} for three-parameter logistic regression model with fixed guessing for both groups,
\code{3PLdg} for three-parameter logistic regression model with fixed inattention for both groups, or
\code{4PLcgdg} for four-parameter logistic regression model with fixed guessing and inattention
parameter for both groups.
}
\examples{
\dontrun{
# loading data based on GMAT
data(GMAT)

Data  <- GMAT[, colnames(GMAT) != "group"]
group <- GMAT[, "group"]

# starting values for 3PL model
startNLR(Data, group, model = "3PL")
}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
adela.drabinova@gmail.com \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr

Karel Zvara \cr
Faculty of Mathematics and Physics, Charles University \cr
}
\references{
Drabinova, A. and Martinkova P. (2016). Detection of Differenctial Item Functioning Based on Non-Linear Regression, Technical Report, V-1229, \url{http://hdl.handle.net/11104/0259498}.
}

