#' Data Set Based on Graduate Management Admission Test with the Same Total Score Distribution for Groups
#'
#' @description The \code{GMATtest} data set is generated data set based on parameters from
#' Graduate Management Admission Test (GMAT) data set (Kingston et al., 1985). First two items
#' were considered to function differently in uniform and non-uniform way respectively.
#' The data set represents responses of 2,000 subjects to multiple-choice test of 20 items.
#' Aditionally, 4 possible answers on all items were generated, coded A, B, C and D. The column
#' \code{group} represents group membership, where 0 represents reference group and 1 represent
#' focal group. Groups are the same size (i.e. 1,000 per group). The distributions of total scores
#' (sum of correct answers) are the same for both reference and focal group (Martinkova et al., 2016).
#' The column \code{criterion} represents generated continuous variable which is intended to be predicted
#' by test.
#'
#' @usage data(GMATtest)
#'
#' @author
#' Adela Drabinova \cr
#' Institute of Computer Science, The Czech Academy of Sciences \cr
#' Faculty of Mathematics and Physics, Charles University \cr
#' adela.drabinova@gmail.com \cr
#'
#' Patricia Martinkova \cr
#' Institute of Computer Science, The Czech Academy of Sciences \cr
#' martinkova@cs.cas.cz \cr
#'
#' @references
#' Kingston, N., Leary, L., and Wightman, L. (1985). An Exploratory Study of the Applicability of Item Response Theory Methods to the Graduate Management Admission Test. ETS Research Report Series, 1985(2) : 1-64.
#'
#' Martinkova, P., Drabinova, A., Liaw Y.-L., Sanders E. A., McFarland J. L., Price R. M. (2016). Using DIF Analysis to Reveal Potential Equity Gaps in Conceptual Assessments. In review.
#'
#' @keywords datasets
#'
#' @seealso \code{\link{GMAT}}, \code{\link{GMATkey}}
#'
#' @format A \code{GMAT} data frame consists of 2,000 observations on the following 21 variables.
#' The first 20 columns represents answers of subject to an items of the test. The 21st column is
#' vector of group membership; values 0 and 1 refer to reference and focal group. The 22nd column is vector
#' representing variable which is intended to be predicted by test.
#' Correct answers are presented in \code{\link{GMATkey}} data set.
"GMATtest"

