% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difORD.R
\name{predict.difORD}
\alias{predict.difORD}
\title{Predicted values for an object of \code{"difORD"} class.}
\usage{
\method{predict}{difORD}(object, item = "all", match, group, type = "category", ...)
}
\arguments{
\item{object}{an object of \code{"difORD"} class.}

\item{item}{numeric or character: either character \code{"all"} to
apply for all converged items (default), or a vector of item
names (column names of \code{Data}), or item identifiers
(integers specifying the column number).}

\item{match}{numeric: matching criterion for new observations.}

\item{group}{numeric: group membership for new observations.}

\item{type}{character: type of probability to be computed. Either
\code{"category"} for category probabilities or
\code{"cumulative"} for cumulative probabilities. Cumulative
probabilities are available only for cumulative logit model.}

\item{...}{other generic parameters for \code{predict()} function.}
}
\description{
S3 method for predictions from the model used in the
  object of \code{"difORD"} class.
}
\examples{
\dontrun{
# loading data
data(dataMedicalgraded, package = "ShinyItemAnalysis")
Data <- dataMedicalgraded[, 1:5] # items
group <- dataMedicalgraded[, 101] # group membership variable
match <- rowSums(dataMedicalgraded[, 1:100]) # matching criterion

# testing both DIF effects with cumulative logit model
(x <- difORD(Data, group, match = match, focal.name = 1, model = "cumulative"))

# fitted values
predict(x, item = "X2003")

# predicted values
predict(x, item = "X2003", match = 350, group = c(0, 1))
predict(x, item = "X2003", match = 350, group = c(0, 1), type = "cumulative")
predict(x, item = c("X2001", "X2003"), match = 350, group = c(0, 1))

# testing both DIF effects with adjacent category logit model
(x <- difORD(Data, group, match = match, focal.name = 1, model = "adjacent"))

# fitted values
predict(x, item = "X2003")

# predicted values
predict(x, item = "X2003", match = 350, group = c(0, 1))
predict(x, item = c("X2001", "X2003"), match = 350, group = c(0, 1))
}

}
\references{
Hladka, A. & Martinkova, P. (2020). difNLR: Generalized logistic regression models for DIF and DDF detection.
The R Journal, 12(1), 300--323, \doi{10.32614/RJ-2020-014}.
}
\seealso{
\code{\link[difNLR]{difORD}} for DIF detection among ordinal data using either cumulative logit or adjacent category logit model. \cr
\code{\link[stats]{predict}} for generic function for prediction.
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
