% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffeqr.R
\name{jitoptimize_ode}
\alias{jitoptimize_ode}
\title{Jit Optimize an ODEProblem}
\usage{
jitoptimize_ode(de, prob)
}
\arguments{
\item{de}{the current diffeqr environment}

\item{prob}{an ODEProblem}
}
\description{
This function JIT Optimizes and ODEProblem utilizing the Julia ModelingToolkit
and JIT compiler.
}
\examples{

\donttest{ ## diffeq_setup() is time-consuming and requires Julia+DifferentialEquations.jl
de <- diffeqr::diffeq_setup()
f <- function(u,p,t) {
  du1 = p[1]*(u[2]-u[1])
  du2 = u[1]*(p[2]-u[3]) - u[2]
  du3 = u[1]*u[2] - p[3]*u[3]
  return(c(du1,du2,du3))
}
u0 <- c(1.0,0.0,0.0)
tspan <- c(0.0,100.0)
p <- c(10.0,28.0,8/3)
prob <- de$ODEProblem(f, u0, tspan, p)
fastprob <- diffeqr::jitoptimize_ode(de,prob)
sol <- de$solve(fastprob,de$Tsit5())
}

}
