% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isomap.R
\docType{class}
\name{Isomap-class}
\alias{Isomap-class}
\alias{Isomap}
\title{Isomap embedding}
\description{
An S4 Class implementing the Isomap Algorithm
}
\details{
The Isomap algorithm approximates a manifold using geodesic
distances on a k nearest neighbor graph. Then classical scaling is
performed on the resulting distance matrix.
}
\section{Slots}{

\describe{
\item{\code{fun}}{A function that does the embedding and returns a
dimRedResult object.}

\item{\code{stdpars}}{The standard parameters for the function.}
}}

\section{General usage}{

Dimensionality reduction methods are S4 Classes that either be used
directly, in which case they have to be initialized and a full
list with parameters has to be handed to the \code{@fun()}
slot, or the method name be passed to the embed function and
parameters can be given to the \code{...}, in which case
missing parameters will be replaced by the ones in the
\code{@stdpars}.
}

\section{Parameters}{

Isomap can take the following parameters:
\describe{
  \item{knn}{The number of nearest neighbors in the graph. Defaults to 50.}
  \item{ndim}{The number of embedding dimensions, defaults to 2.}
  \item{get_geod}{Should the geodesic distance matrix be kept,
                  if \code{TRUE}, access it as \code{getOtherData(x)$geod}}
}
}

\section{Implementation}{


The dimRed package uses its own implementation of Isomap which also
comes with an out of sample extension (known as landmark
Isomap). The default Isomap algorithm scales computationally not
very well, the implementation here uses \code{\link[RANN]{nn2}} for
a faster search of the nearest neighbors.  If data are too large it
may be useful to fit a subsample of the data and use the
out-of-sample extension for the other points.
}

\examples{
dat <- loadDataSet("3D S Curve", n = 500)
emb <- embed(dat, "Isomap", knn = 10)
plot(emb)

## or simpler, use embed():
samp <- sample(nrow(dat), size = 200)
emb2 <- embed(dat[samp], "Isomap", .mute = NULL, knn = 10)
emb3 <- predict(emb2, dat[-samp])

plot(emb2, type = "2vars")
plot(emb3, type = "2vars")

}
\references{
Tenenbaum, J.B., Silva, V. de, Langford, J.C., 2000. A Global Geometric
Framework for Nonlinear Dimensionality Reduction. Science 290, 2319-2323.
https://doi.org/10.1126/science.290.5500.2319
}
\seealso{
Other dimensionality reduction methods: 
\code{\link{AutoEncoder-class}},
\code{\link{DRR-class}},
\code{\link{DiffusionMaps-class}},
\code{\link{DrL-class}},
\code{\link{FastICA-class}},
\code{\link{FruchtermanReingold-class}},
\code{\link{HLLE-class}},
\code{\link{KamadaKawai-class}},
\code{\link{LLE-class}},
\code{\link{MDS-class}},
\code{\link{NNMF-class}},
\code{\link{PCA-class}},
\code{\link{PCA_L1-class}},
\code{\link{UMAP-class}},
\code{\link{dimRedMethod-class}},
\code{\link{dimRedMethodList}()},
\code{\link{kPCA-class}},
\code{\link{nMDS-class}},
\code{\link{tSNE-class}}
}
\concept{dimensionality reduction methods}
