% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/viz_ellipse.R, R/viz_hull.R
\docType{methods}
\name{viz_ellipses}
\alias{viz_ellipses}
\alias{viz_ellipses-method}
\alias{viz_hull}
\alias{viz_hull-method}
\alias{viz_confidence}
\alias{viz_confidence-method}
\alias{viz_tolerance}
\alias{viz_tolerance-method}
\alias{viz_ellipses,MultivariateAnalysis-method}
\alias{viz_tolerance,MultivariateAnalysis-method}
\alias{viz_tolerance,BootstrapCA-method}
\alias{viz_confidence,MultivariateAnalysis-method}
\alias{viz_confidence,BootstrapCA-method}
\alias{viz_hull,MultivariateAnalysis-method}
\alias{viz_hull,BootstrapCA-method}
\title{Plot Envelopes}
\usage{
viz_ellipses(x, ...)

viz_hull(x, ...)

viz_confidence(x, ...)

viz_tolerance(x, ...)

\S4method{viz_ellipses}{MultivariateAnalysis}(
  x,
  ...,
  group = NULL,
  type = c("tolerance", "confidence"),
  level = 0.95,
  margin = 1,
  axes = c(1, 2),
  color = NULL,
  fill = FALSE,
  symbol = FALSE
)

\S4method{viz_tolerance}{MultivariateAnalysis}(
  x,
  ...,
  margin = 1,
  axes = c(1, 2),
  group = NULL,
  level = 0.95,
  color = NULL,
  fill = FALSE,
  symbol = FALSE
)

\S4method{viz_tolerance}{BootstrapCA}(
  x,
  ...,
  margin = 1,
  axes = c(1, 2),
  level = 0.95,
  color = FALSE,
  fill = FALSE,
  symbol = FALSE
)

\S4method{viz_confidence}{MultivariateAnalysis}(
  x,
  ...,
  margin = 1,
  axes = c(1, 2),
  group = NULL,
  level = 0.95,
  color = NULL,
  fill = FALSE,
  symbol = FALSE
)

\S4method{viz_confidence}{BootstrapCA}(
  x,
  ...,
  margin = 1,
  axes = c(1, 2),
  level = 0.95,
  color = FALSE,
  fill = FALSE,
  symbol = FALSE
)

\S4method{viz_hull}{MultivariateAnalysis}(
  x,
  ...,
  margin = 1,
  axes = c(1, 2),
  group = NULL,
  color = NULL,
  fill = FALSE,
  symbol = FALSE
)

\S4method{viz_hull}{BootstrapCA}(
  x,
  ...,
  margin = 1,
  axes = c(1, 2),
  color = FALSE,
  fill = FALSE,
  symbol = FALSE
)
}
\arguments{
\item{x}{An object from which to wrap observations (a \code{\linkS4class{CA}},
\code{\linkS4class{MCA}} or \code{\linkS4class{PCA}} object).}

\item{...}{Further \link[graphics:par]{graphical parameters} to be passed to
\code{\link[graphics:polygon]{graphics::polygon()}}.}

\item{group}{A vector specifying the group an observation belongs to.}

\item{type}{A \code{\link{character}} string specifying the ellipse to draw.
It must be one of "\code{tolerance}" or "\code{confidence}").
Any unambiguous substring can be given.}

\item{level}{A \code{\link{numeric}} vector specifying the confidence/tolerance level.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript which the
data will be returned: \code{1} indicates individuals/rows (the default), \code{2}
indicates variables/columns.}

\item{axes}{A length-two \code{\link{numeric}} vector giving the dimensions
for which to compute results.}

\item{color}{The colors for borders (will be mapped to \code{group}).
Ignored if set to \code{FALSE}. If \code{NULL}, the default color scheme will be used.}

\item{fill}{The background colors (will be mapped to \code{group}).
Ignored if set to \code{FALSE}.}

\item{symbol}{A vector of symbols (will be mapped to \code{group}).
Ignored if set to \code{FALSE}.}
}
\value{
\verb{viz_*()}is called for its side-effects: it results in a graphic being
displayed. Invisibly returns \code{x}.
}
\description{
Plot Envelopes
}
\examples{
## Load data
data("iris")

## Compute principal components analysis
X <- pca(iris, scale = TRUE, sup_quali = "Species")

## Plot with convex hulls
col <- c("#004488", "#DDAA33", "#BB5566")
viz_rows(X, extra_quali = iris$Species, color = col)
viz_hull(X, group = iris$Species, color = col)

## Plot with tolerance ellipses
col <- c("#004488", "#DDAA33", "#BB5566")
viz_rows(X, extra_quali = iris$Species, color = col)
viz_tolerance(X, group = iris$Species, color = col)
}
\seealso{
Other plot methods: 
\code{\link{biplot}()},
\code{\link{plot}()},
\code{\link{screeplot}()},
\code{\link{viz_contributions}()},
\code{\link{viz_individuals}()},
\code{\link{viz_variables}()},
\code{\link{wrap}}
}
\author{
N. Frerebeau
}
\concept{plot methods}
