% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_date_xx.R
\name{scale_date_xx}
\alias{scale_date_xx}
\alias{scale_x_date_yq}
\alias{scale_y_date_yq}
\alias{scale_x_date_ym}
\alias{scale_y_date_ym}
\alias{scale_x_date_yw}
\alias{scale_y_date_yw}
\title{ggplot2 Scales For date_xx Objects}
\usage{
scale_x_date_yq(name = "Quarter", breaks = date_yq_breaks(),
  labels = ggplot2::waiver(), limits = NULL, position = "bottom")

scale_y_date_yq(name = "Quarter", breaks = date_yq_breaks(),
  labels = ggplot2::waiver(), limits = NULL, position = "left")

scale_x_date_ym(name = "Month", breaks = date_ym_breaks(),
  labels = ggplot2::waiver(), limits = NULL, position = "bottom")

scale_y_date_ym(name = "Month", breaks = date_ym_breaks(),
  labels = ggplot2::waiver(), limits = NULL, position = "left")

scale_x_date_yw(name = "Week", breaks = date_yw_breaks(),
  labels = ggplot2::waiver(), limits = NULL, position = "bottom")

scale_y_date_yw(name = "Week", breaks = date_yw_breaks(),
  labels = ggplot2::waiver(), limits = NULL, position = "left")
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{ggplot2::waiver()} for automatic breaks (see \code{\link[=date_xx_breaks]{date_xx_breaks()}})
\item A \code{date_xx} vector of breaks
\item A function that takes the limits as input and returns breaks as output
}}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{ggplot2::waiver()} for the default labels computed by the
transformation object
\item A \code{character} vector giving labels (must be same length as \code{breaks}, so
it's a good idea to specify manual breaks if you use manual labels)
\item A function that takes the breaks as input and returns labels as output
}}

\item{limits}{A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum.}

\item{position}{The position of the axis. "left" or "right" for vertical
scales, "top" or "bottom" for horizontal scales}
}
\description{
The \code{scale_*_date_**} functions provide nice defaults for plotting
the appropriate \link{date_xx} subclass, but come with a limited number of
configuration options. If you require more finetuning, you can convert
\link{date_xx} vectors with \code{\link[=as.Date]{as.Date()}} and use \code{\link[ggplot2:scale_x_date]{ggplot2::scale_x_date()}}.
}
\examples{
if (require("ggplot2", quietly = TRUE)){

dd <- data.frame(date = seq(date_yq(2016, 1), date_yq(2018, 1)), V1 = 1:9)
p <- ggplot(dd, aes(x = date, y = V1)) +
  geom_point()

p  # automatically uses the proper scale
p + scale_x_date_yq("quarters with default spacing")
p + scale_x_date_yq(breaks = date_yq_breaks(3))


# Different ways to specify breaks and labels
p <- ggplot(
  data.frame(date = seq(date_yq(2012, 4), date_yq(2018, 4)), V1 = 1:25),
  aes(x = date, y = V1)
) +
  geom_point()

p + scale_x_date_yq(labels = waiver()) + ggtitle("auto Labels")
p + scale_x_date_yq(labels = NULL) + ggtitle("no Labels")
p + scale_x_date_yq(labels = LETTERS[1:4]) + ggtitle("manual Labels")
p + scale_x_date_yq(labels = format_yq_iso) + ggtitle("function Labels")

p + scale_x_date_yq(breaks = waiver()) + ggtitle("auto breaks")
p + scale_x_date_yq(breaks = NULL) + ggtitle("no breaks")
p + scale_x_date_yq(breaks = date_yq(2013, 2:3) ) + ggtitle("manual breaks")
p + scale_x_date_yq(breaks = date_yq_breaks(1) ) + ggtitle("function breaks")
}
}
