% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-flex-div.R
\name{html_asis}
\alias{html_asis}
\title{Escape HTML strings}
\usage{
html_asis(s, space = TRUE)
}
\arguments{
\item{s}{characters}

\item{space}{whether to also escape white space, default is true.}
}
\value{
An R string
}
\description{
Escape HTML strings so that they will be displayed
'as-is' in websites.
}
\examples{

ui <- flex_div(
  shiny::textInput('id', ' ', width = '100\%',
                   value = 'Height not aligned'),
  actionButtonStyled('ok', 'Button1', width = '100\%',),
  shiny::textInput('id2', html_asis(' '), width = '100\%',
                   value = 'Heights aligned'),
  actionButtonStyled('ok2', 'Button2', width = '100\%',),
  ncols = 2
)
if(interactive()){
  shiny::shinyApp(ui = shiny::fluidPage(shiny::fluidRow(ui)),
                  server = function(input, output, session){})
}

}
