% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp-fastquantile.R
\name{fastquantile}
\alias{fastquantile}
\title{Calculate single quantile for numerical values}
\usage{
fastquantile(x, q)
}
\arguments{
\item{x}{numerical vector (integers or double)}

\item{q}{number from 0 to 1}
}
\value{
Identical to \code{quantile(x, q, na.rm=TRUE)}
}
\description{
Slightly faster than \code{\link[stats]{quantile}} with
\code{na.rm=TRUE}. The internal implementation uses the 'C++' function
\code{std::nth_element}, which is significantly faster than base R
implementation when the length of input \code{x} is less than \code{1e7}.
}
\examples{

# create input x with NAs
x <- rnorm(10000)
x[sample(10000, 10)] <- NA

# compute median
res <- fastquantile(x, 0.5)
res

# base method
res == quantile(x, 0.5, na.rm = TRUE)
res == median(x, na.rm = TRUE)

# Comparison
microbenchmark::microbenchmark(
  {
    fastquantile(x, 0.5)
  },{
    quantile(x, 0.5, na.rm = TRUE)
  },{
    median(x, na.rm = TRUE)
  }
)

}
