% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{capture_expr}
\alias{capture_expr}
\title{Captures Evaluation Output of Expressions as One Single String}
\usage{
capture_expr(expr, collapse = "\\n", type = c("output", "message"), ...)
}
\arguments{
\item{expr}{R expression}

\item{collapse}{character to concatenate outputs}

\item{type, ...}{passed to \code{\link[utils]{capture.output}}}
}
\value{
Character of length 1: output captured by
\code{\link[utils]{capture.output}}
}
\description{
Evaluate expression and captures output as characters, then
concatenate as one single string.
}
\examples{

x <- data.frame(a=1:10)
x_str <- capture_expr({
  print(x)
})

x_str

cat(x_str)


}
