% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/geneStats.R
\name{geneStats}
\alias{geneStats}
\title{Gene Level Statistics}
\usage{
geneStats(T, method="OSP")
}
\arguments{
\item{T}{a vector of statistics (z-scores converted) with each element correspond to a treatment vs control
comparison.}

\item{method}{the p-value integration method for combining accross multiple treatments. Available methods
are Stouffer, OSP, Fisher, and maxP. The default method is OSP.}
}
\value{
a p-value after integration across treatments.
}
\description{
Takes a vector of statistics with each element corresponds to a treatment vs control comparison,
and calculates a combined statistics accross multiple treatments.
}
\examples{
# load the example data
data(PM)

# convert statistics into z-scores
PM.zscores <- apply(PM, 2, function(x){qnorm(rank(x)/(nrow(PM)+1))})

# Rotate the matrix by contrast 1, -1, -1 (i.e. up-regulation, down-regulation, dow-regulation).
PM.rotated <- rotate3d(PM.zscores, contrast = c(1, -1, -1))

# combine rotated statistics across treatments
gene.pvalues <- apply(PM.rotated, 1, geneStats)
}

