% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2023-04-24_DisclosuR.R
\name{impression_offsetting}
\alias{impression_offsetting}
\title{Impression offsetting}
\usage{
impression_offsetting(event_data, press_data_categorized)
}
\arguments{
\item{event_data}{An R data that contains three columns which have to be labeled "date_announced", "cusip", and "ID".
The date_announced column contains the dates of the events for which impression offsetting is calculated.
The cusip column contains the 8-digit cusip of the companies for which impression offsetting is calculated.
The ID column should contain a unique ID that identifies the specific event.}

\item{press_data_categorized}{An R data frame with each row representing one 'newswire' article. The columns indicate the title, text,
'newswire', date, and weekday. It should be the outcome of \code{\link[disclosuR]{newswire_segmenter}} in which both
the argument sentiment and text_clustering have been set to TRUE.}
}
\value{
An R data frame which contains the column of the event_data plus three columns for the baseline announcements
(positive, neutral, and negative) and three columns for the impression offsetting announcements (positive, neutral, and negative).
}
\description{
Takes an event data set containing of dates and CUSIPs which have to correspond
to a press data frame compiled by the function \code{\link{newswire_segmenter_folder}}.
}
\examples{
\dontrun{
impression_offsetting(event_data, press_data)
}
}
