% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair.plot.R
\name{pair.plot}
\alias{pair.plot}
\title{Plots pairwise comparisons}
\usage{
pair.plot(data, what, col = c("black", "white"), legend = FALSE, binary,
  diag, add, lower = TRUE, ...)
}
\arguments{
\item{data}{A \code{matrix} or a \code{data.frame} object with comparisons' pair names as row names. The number of rows must be equal to a pairwise combination of \code{n} elements (see details).}

\item{what}{A \code{numeric} or \code{character} value designating which column to plot.}

\item{col}{The two extremes of a color gradient (default = \code{c("black", "white")}).}

\item{legend}{Logical, whether to plot the legend or not.}

\item{binary}{Optional, if the results must be binary, a \code{numeric} value for the threshold of acceptance (values greater will be 1, lower will be 0).}

\item{diag}{Optional, can be \code{"max"} or \code{"min"} or a single \code{numeric} value.}

\item{add}{Optional, whether to add significance tokens can be \code{numeric} for a point type to print (\code{pch}) or \code{"character"} to print (e.g. \code{"*"}).}

\item{lower}{Optional, logical, whether to add tokens for values lower than \code{binary} (default is \code{TRUE}; \code{FALSE} will add tokens for values bigger than \code{binary}).}

\item{...}{Any other options to be passed to \code{\link[graphics]{plot}}.}
}
\description{
Plots pairwise comparisons from a data frame (typically output from \code{\link{test.dispRity}}).
}
\details{
The number of rows (i.e. comparisons) in \code{matrix} must be equal to the results of a pairwise combination.
In general, the number of rows \code{x} must satisfy the equation: \eqn{x  = n^2 / 2 - n / 2} where \code{n} must be an integer greater or equal than 2.
}
\examples{
## A small matrix of two pairwise comparisons of seven elements (2*21 comparisons)
data <- matrix(data = runif(42), ncol = 2)

## Plotting the first column as a pairwise comparisons
pair.plot(data, what = 1, col = c("orange", "blue"), legend = TRUE, diag = 1)

## Adding some tokens for each value below 0.2 in the second column
pair.plot(data, what = 2, binary = 0.2, add = "*", cex = 2)

## Loading disparity data
data(disparity)

## Testing the pairwise difference between slices
tests <- test.dispRity(disparity, test = wilcox.test, correction = "bonferroni")

## Plotting the significance
pair.plot(as.data.frame(tests), what = "p.value", binary = 0.05)

}
\seealso{
\code{\link{test.dispRity}}.
}
\author{
Thomas Guillerme
}
