% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updates.R
\name{updates}
\alias{updates}
\alias{update_price}
\alias{update_datetime}
\alias{update_quantity}
\alias{update_portfolio}
\alias{update_realized_and_paper}
\alias{update_timeseries_DE}
\alias{update_expectedvalue}
\title{Update results over time}
\usage{
update_price(
  portfolio_quantity,
  portfolio_price,
  transaction_quantity,
  transaction_price,
  transaction_type
)

update_datetime(
  portfolio_quantity,
  portfolio_datetime,
  transaction_quantity,
  transaction_datetime,
  transaction_type
)

update_quantity(portfolio_quantity, transaction_quantity)

update_portfolio(
  portfolio,
  transaction_asset,
  transaction_quantity,
  transaction_price,
  transaction_datetime,
  transaction_type
)

update_realized_and_paper(realized_and_paper, new_realized_and_paper, method)

update_timeseries_DE(
  timeseries_DE,
  realized_and_paper,
  gainslosses,
  transaction_id,
  assets_time_series_DE = NULL,
  method
)

update_expectedvalue(realized_and_paper, num_transaction_assets)
}
\arguments{
\item{portfolio_quantity}{Numeric value. The portfolio quantity of the traded asset.}

\item{portfolio_price}{Numeric value. The portfolio price of the traded asset.}

\item{transaction_quantity}{Numeric value. The quantity of the traded asset.}

\item{transaction_price}{Numeric value. The market price of the traded asset.}

\item{transaction_type}{Character string. Either "B" = buy or "S" = sell.}

\item{portfolio_datetime}{POSIXct value. The date-time of the traded asset.}

\item{transaction_datetime}{POSIXct value. The date-time at which the transaction
is going to occur.}

\item{portfolio}{Data frame of the investor's portfolio at time t.}

\item{transaction_asset}{Character string. The name of the traded asset.}

\item{realized_and_paper}{Data frame containing the realized and paper gains and
losses results to be updated.}

\item{new_realized_and_paper}{Data frame containing the realized and paper gains and
losses results related to the new transaction.}

\item{method}{Character string. The method used to compute papers.
Allowed values are "count", "total", "value", "duration" and "all".}

\item{timeseries_DE}{Data frame of time series disposition effect results.}

\item{transaction_id}{Numeric, the id of transaction.}

\item{assets_time_series_DE}{Character vector of assets' names as contained
into \code{portfolio_transactions} on which to compute the time series disposition
effect.}

\item{num_transaction_assets}{Data frame containing the number of transactions for
each asset traded by the investor.}
}
\value{
The updated input data.
}
\description{
Update investor's portfolio, realized and paper results
and time series disposition effect computations.
}
\section{Functions}{
\itemize{
\item \code{update_price}: Update the portfolio price of the traded asset.

\item \code{update_datetime}: Update the portfolio datetime of the traded asset.

\item \code{update_quantity}: Update the portfolio quantity of the traded asset.

\item \code{update_portfolio}: Update the portfolio with the new quantity, price
and datetime of the traded asset.

\item \code{update_realized_and_paper}: Update the realized and paper gains and losses
results with the results obtained on the last occurred transaction.

\item \code{update_timeseries_DE}: Update the time series disposition effect
averaging values over time.

\item \code{update_expectedvalue}: Update the realized and paper gains and losses
results averaging the total value by the number of transactions
for each asset.
}}

\keyword{internal}
