% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{balance_observations}
\alias{balance_observations}
\title{Balance observations}
\usage{
balance_observations(data, groups, n_obs)
}
\arguments{
\item{data}{A data frame with the dissolution profile data in wide format.}

\item{groups}{A logical vector specifying different groups.}

\item{n_obs}{An integer specifying the minimal number of observations each
group should have.}
}
\value{
The original data frame extended by the observations necessary to
have a balanced number of observations between the two groups.
}
\description{
The function \code{balance_observations()} balances the number of
observations of two groups.
}
\details{
First, the largest common value between \code{n_obs} and the number
of observations of the two groups specified by \code{groups} is sought. Then,
the number of observations of the two groups are extended according to the
value found. Extension means that the maximal possible number of
observations is duplicated in order to obtain the required number of
observations. Thus, in the data frame that is returned the two groups will
have the same number of observations. Either the number of observations of
both groups is extended (to match the number of \code{n_obs}), or, if
\code{n_obs} and the number of observations of one of the two groups is
equal, only the number of observations of one of the two groups.
}
\keyword{internal}
