% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsl_burst.R
\name{tsl_burst}
\alias{tsl_burst}
\title{Multivariate TSL to Univariate TSL}
\usage{
tsl_burst(tsl = NULL, sep = "__")
}
\arguments{
\item{tsl}{(required, list) Time series list. Default: NULL}

\item{sep}{(required, character string) separator between the time series name and the column name. Default: "__"}
}
\value{
time series list: list of univariate zoo objects with a column named "x".
}
\description{
Takes a time series list with multivariate zoo objects to generate a new one with one univariate zoo objects per variable. A time series list with the the zoo objects "A" and "B", each with the columns "a", "b", and "c", becomes a time series list with the zoo objects "A__a", "A__b", "A__c", "B__a", "B__b", and "B__c". The only column of each new zoo object is named "x".
}
\examples{

tsl <- tsl_simulate(
  n = 2,
  time_range = c(
    "2010-01-01",
    "2024-12-31"
  ),
  cols = 3
)

tsl_names_get(tsl)
tsl_colnames_get(tsl)

if(interactive()){
  tsl_plot(tsl)
}

tsl <- tsl_burst(tsl)

tsl_names_get(tsl)
tsl_colnames_get(tsl)

if(interactive()){
  tsl_plot(tsl)
}
}
\seealso{
Other tsl_management: 
\code{\link{tsl_colnames_clean}()},
\code{\link{tsl_colnames_get}()},
\code{\link{tsl_colnames_prefix}()},
\code{\link{tsl_colnames_set}()},
\code{\link{tsl_colnames_suffix}()},
\code{\link{tsl_count_NA}()},
\code{\link{tsl_diagnose}()},
\code{\link{tsl_handle_NA}()},
\code{\link{tsl_join}()},
\code{\link{tsl_names_clean}()},
\code{\link{tsl_names_get}()},
\code{\link{tsl_names_set}()},
\code{\link{tsl_names_test}()},
\code{\link{tsl_ncol}()},
\code{\link{tsl_nrow}()},
\code{\link{tsl_repair}()},
\code{\link{tsl_subset}()},
\code{\link{tsl_time}()},
\code{\link{tsl_to_df}()}
}
\concept{tsl_management}
