% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_rescale_vector.R
\name{utils_rescale_vector}
\alias{utils_rescale_vector}
\title{Rescale Numeric Vector to a New Data Range}
\usage{
utils_rescale_vector(
  x = NULL,
  new_min = 0,
  new_max = 1,
  old_min = NULL,
  old_max = NULL
)
}
\arguments{
\item{x}{(required, numeric vector) Numeric vector. Default: \code{NULL}}

\item{new_min}{(optional, numeric) New minimum value. Default: \code{0}}

\item{new_max}{(optional_numeric) New maximum value. Default: \code{1}}

\item{old_min}{(optional, numeric) Old minimum value. Default: \code{NULL}}

\item{old_max}{(optional_numeric) Old maximum value. Default: \code{NULL}}
}
\value{
numeric vector
}
\description{
Rescale Numeric Vector to a New Data Range
}
\examples{

 out <- utils_rescale_vector(
   x = stats::rnorm(100),
   new_min = 0,
   new_max = 100,
   )

 out

}
\seealso{
Other tsl_processing_internal: 
\code{\link{utils_drop_geometry}()},
\code{\link{utils_global_scaling_params}()},
\code{\link{utils_optimize_loess}()},
\code{\link{utils_optimize_spline}()}
}
\concept{tsl_processing_internal}
