% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{psi_dtw_cpp}
\alias{psi_dtw_cpp}
\title{(C++) Psi Dissimilarity Score of Two Time-Series}
\usage{
psi_dtw_cpp(
  x,
  y,
  distance = "euclidean",
  diagonal = TRUE,
  weighted = TRUE,
  ignore_blocks = FALSE,
  bandwidth = 1
)
}
\arguments{
\item{x}{(required, numeric matrix) of same number of columns as 'y'.}

\item{y}{(required, numeric matrix) time series.}

\item{distance}{(optional, character string) distance name from the "names"
column of the dataset \code{distances} (see \code{distances$name}). Default: "euclidean".}

\item{diagonal}{(optional, logical). If TRUE, diagonals are included in the
computation of the cost matrix. Default: TRUE.}

\item{weighted}{(optional, logical). Only relevant when diagonal is TRUE. When TRUE,
diagonal cost is weighted by y factor of 1.414214 (square root of 2). Default: TRUE.}

\item{ignore_blocks}{(optional, logical). If TRUE, blocks of consecutive path
coordinates are trimmed to avoid inflating the psi distance. Default: FALSE.}

\item{bandwidth}{(required, numeric) Size of the Sakoe-Chiba band at
both sides of the diagonal used to constrain the least cost path. Expressed
as a fraction of the number of matrix rows and columns. Unrestricted by default.}
}
\value{
numeric
}
\description{
Computes the psi score of two time series \code{y} and \code{x}
with the same number of columns.
NA values should be removed before using this function.
If the selected distance function is "chi" or "cosine", pairs of zeros should
be either removed or replaced with pseudo-zeros (i.e. 0.00001).
}
\seealso{
Other Rcpp_dissimilarity_analysis: 
\code{\link{psi_equation_cpp}()},
\code{\link{psi_ls_cpp}()},
\code{\link{psi_null_dtw_cpp}()},
\code{\link{psi_null_ls_cpp}()}
}
\concept{Rcpp_dissimilarity_analysis}
