% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/querycount.R
\name{HEQueryCountMaster}
\alias{HEQueryCountMaster}
\title{Create a homomorphic computation query count master object to employ worker objects generated by \code{\link[=HEQueryCountWorker]{HEQueryCountWorker()}}}
\description{
\code{HEQueryCountMaster} objects instantiate and run a distributed homomorphic query count computation; they're instantiated by non-cooperating parties (NCPs)
}
\seealso{
\code{\link[=HEQueryCountWorker]{HEQueryCountWorker()}} which goes hand-in-hand with this object
}
\section{Super class}{
\code{\link[distcomp:QueryCountMaster]{distcomp::QueryCountMaster}} -> \code{HEQueryCountMaster}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{pubkey}}{the master's public key visible to everyone}

\item{\code{pubkey_bits}}{the number of bits in the public key (used for reconstructing public key remotely by serializing to character)}

\item{\code{pubkey_n}}{the \code{n} for the public key used for reconstructing public key remotely}

\item{\code{den}}{the denominator for rational arithmetic}

\item{\code{den_bits}}{the number of bits in the denominator used for reconstructing denominator remotely}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{HEQueryCountMaster$new()}}
\item \href{#method-setParams}{\code{HEQueryCountMaster$setParams()}}
\item \href{#method-kosher}{\code{HEQueryCountMaster$kosher()}}
\item \href{#method-queryCount}{\code{HEQueryCountMaster$queryCount()}}
\item \href{#method-cleanup}{\code{HEQueryCountMaster$cleanup()}}
\item \href{#method-run}{\code{HEQueryCountMaster$run()}}
\item \href{#method-clone}{\code{HEQueryCountMaster$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="distcomp" data-topic="QueryCountMaster" data-id="addSite">}\href{../../distcomp/html/QueryCountMaster.html#method-addSite}{\code{distcomp::QueryCountMaster$addSite()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distcomp" data-topic="QueryCountMaster" data-id="getSites">}\href{../../distcomp/html/QueryCountMaster.html#method-getSites}{\code{distcomp::QueryCountMaster$getSites()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{HEQueryCountMaster} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountMaster$new(defn, partyNumber, debug = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{defn}}{the computation definition}

\item{\code{partyNumber}}{the party number of the NCP that this object belongs to (1 or 2)}

\item{\code{debug}}{a flag for debugging, default \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new \code{HEQueryCountMaster} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setParams"></a>}}
\subsection{Method \code{setParams()}}{
Set some parameters of the \code{HEQueryCountMaster} object for homomorphic computations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountMaster$setParams(pubkey_bits, pubkey_n, den_bits)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pubkey_bits}}{the number of bits in public key}

\item{\code{pubkey_n}}{the \code{n} for the public key}

\item{\code{den_bits}}{the number of bits in the denominator (power of 2) used in rational approximations}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-kosher"></a>}}
\subsection{Method \code{kosher()}}{
Check if inputs and state of object are sane. For future use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountMaster$kosher()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} or \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-queryCount"></a>}}
\subsection{Method \code{queryCount()}}{
Run the distributed query count, associate it with a token, and return the result
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountMaster$queryCount(token)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{token}}{a token to use as key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the partial result as a list of encrypted items with components \code{int} and \code{frac}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cleanup"></a>}}
\subsection{Method \code{cleanup()}}{
Cleanup the instance objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountMaster$cleanup()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run"></a>}}
\subsection{Method \code{run()}}{
Run the homomorphic encrypted distributed query count computation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountMaster$run(token)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{token}}{a token to use as key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the partial result as a list of encrypted items with components \code{int} and \code{frac}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountMaster$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
