% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotter.R
\name{plot-Interpreter}
\alias{plot-Interpreter}
\alias{plot.Interpreter}
\title{Plotting method for Interpretor model}
\usage{
\method{plot}{Interpreter}(
  x,
  method = "pdp+ice",
  features = NULL,
  features.2d = NULL,
  clusters = NULL,
  clusterType = "preds",
  smooth = FALSE,
  smooth.bandwidth = NULL,
  smooth.kernel = "normal",
  smooth.npoints = 2 * x$grid.size,
  ...
)
}
\arguments{
\item{x}{Interpreter object to generate plots from}

\item{method}{The type of plot that we want to generate. Must be one of "ice",
"pdp+ice", "pdp", or "ale"}

\item{features}{a vector of feature names that we want to produce 1-D plots for.}

\item{features.2d}{2-D features that we want to produce plots for arguments.
A two-column dataframe of pairs of features to make local
surrogates for. Each row represents a pair of features,
with the names of features as the entries.If
the 'method' parameter is set to "ale", this argument should not
be used.}

\item{clusters}{A number of clusters to cluster the ICE predictions with.
If this is not NULL, one must use the method "ice".}

\item{clusterType}{An indicator specifying what method to use for the clustering.
The possible options are "preds", and "gradient". If "preds" is used, the clusters
will be determined by running K means on the predictions of the ICE functions.
If the "gradient" option is used, the clusters will be determined by running K
means on the numerical gradient of the predictions of the ICE functions. If
this is not NULL, one must use the method "ice".}

\item{smooth}{A binary variable to determine whether to smoothen the plots of the
PDP, ICE, or ALE curves for continuous variables.}

\item{smooth.bandwidth}{The bandwidth for the kernels. They are scaled such that
their quartiles are at 0.25 * bandwidth. By default, this
is set as the maximum difference between the minimum and
maximum of the grid points.}

\item{smooth.kernel}{The type of kernel to be used. Users can input either strings "box"
or "normal". The default is "normal".}

\item{smooth.npoints}{The number of points returned when using the kernel method. By
default, this is twice the number of grid points for that
feature.}

\item{...}{Additiional parameters to pass to the plot function}
}
\value{
A list of plots with 1-d features and 2-d features. For 2-d features with
        one continuous and one categorical feature, the plot is a linear plot of the
        continuous feature with group colors representing the categorical feature.
        For two continuous features, the plot is a heatmap with the shade representing
        the value of the outcome.
}
\description{
Plots the PDP, ALE, or ICE plots for an Interpreter object
}
