% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterSet.R
\name{setParameterValue}
\alias{setParameterValue}
\title{Parameter Value Setter}
\usage{
setParameterValue(object, ..., lst = NULL, error = "warn")
}
\arguments{
\item{object}{Distribution or ParameterSet.}

\item{...}{named parameters and values to update, see details.}

\item{lst}{optional list, see details.}

\item{error}{character, value to pass to \code{stopwarn}.}
}
\value{
An R6 object of class ParameterSet.
}
\description{
Returns the value of the given parameter.
}
\details{
Parameters can be updated in one of two ways, either by passing the parameters to update
as named arguments or as a list with the the list names are parameter IDs and the list values are
the respective values to set the parameters. Using a list may be preferred for parameters that take
multiple values. See examples. If \code{lst} is given then any additional arguments are ignored.

\code{stopwarn} either breaks the code with an error if "error" is given or returns \code{NULL}
with warning otherwise.
}
\section{R6 Usage}{
 $setParameterValue(..., lst = NULL, error = "warn")
}

\examples{
ps <- Normal$new()$parameters()
ps$setParameterValue(mean  = 2, var = 5)$print()

ps <- MultivariateNormal$new()$parameters()
ps$setParameterValue(lst = list(mean = c(1,1)))$print()

}
\seealso{
\code{\link{parameters}} and \code{\link{setParameterValue}}
}
