% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionDecorator_CoreStatistics.R
\name{pgf}
\alias{pgf}
\title{Probability Generating Function}
\usage{
pgf(object, z)
}
\arguments{
\item{object}{Distribution.}

\item{z}{integer to evaluate characteristic function at.}
}
\value{
Probability generating function evaluated at z as a numeric if distribution is discrete,
otherwise NaN.
}
\description{
Probability generating function of a distribution
}
\details{
The probability generating function is defined by
\deqn{pgf_X(z) = E_X[exp(z^x)]}
where X is the distribution and \eqn{E_X} is the expectation of the distribution X.

If an analytic expression isn't available, returns error. To impute a numerical expression, use the
\code{\link{CoreStatistics}} decorator.
}
\section{R6 Usage}{
 $pgf(z)
}

\seealso{
\code{\link{CoreStatistics}} and \code{\link{decorate}}
}
