% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterSet.R
\name{ParameterSet}
\alias{ParameterSet}
\title{Make an R6 Parameter Set for Distributions}
\value{
An R6 object of class ParameterSet.
}
\description{
ParameterSets are passed to a \code{Distribution$new} constructor when
 creating a custom probability distribution that takes parameters.
}
\section{Constructor}{
 ParameterSet$new(id, value, support, settable, updateFunc = NULL, description = NULL)
}

\section{Constructor Arguments}{

\tabular{lll}{
\strong{Argument} \tab \strong{Type} \tab \strong{Details} \cr
\code{id} \tab character \tab unique one-word identifier. \cr
\code{value} \tab numeric \tab initial parameter value. \cr
\code{support} \tab numeric \tab range of values parameter can take. \cr
\code{settable} \tab logical \tab if TRUE the parameter is printed. See Details. \cr
\code{updateFunc = NULL} \tab function \tab evaluated to update parameter. See Details. \cr
\code{description = NULL} \tab character \tab optional description of parameter.
}
}

\section{Constructor Details}{

An R6 ParameterSet is required to construct a custom Probability Distribution that takes parameters.
This constructor ensures that the correct format of parameters is supplied to the distribution.

Every argument can either be given as the type listed above or as a list of that type.
If arguments are provided as a list, then each argument must be of the same length list, with values
as NULL where appropriate. See examples for more.

Each parameter requires a unique one-word \code{id} that is used to get and set parameters
after construction. The parameterisation of the distribution is determined by the parameters
that have \code{settable = TRUE}, this is a slightly confusing term as it actually refers to a parameter
being 'machine-settable'. Here it just means that the given parameter is used in construction and therefore
will be included in a call to \code{$print}. \code{updateFunc} is used to update the parameters not used in
the parameterisation. These should be given as a function that could be understood in the body of a Distribution
and should start with \code{function(self)}, see examples.

Internally after calling \code{$setParameterValue}, \code{$update} is called to update all parameters
with a non-NA \code{updateFunc}.
}

\section{Public Methods}{

 \tabular{ll}{
  \strong{Method} \tab \strong{Link} \cr
  \code{print(hide_cols = c("updateFunc","settable"))} \tab \code{\link{print.ParameterSet}} \cr
  \code{update()} \tab \code{\link{update.ParameterSet}} \cr
  \code{parameters(id = NULL)} \tab \code{\link{parameters}} \cr
  \code{getParameterSupport(id, error = "warn")} \tab \code{\link{getParameterSupport}} \cr
  \code{getParameterValue(id, error = "warn")} \tab \code{\link{getParameterValue}} \cr
  \code{setParameterValue(..., lst = NULL, error = "warn")} \tab \code{\link{setParameterValue}} \cr
  \code{merge(y, ...)} \tab \code{\link{merge.ParameterSet}} \cr
  \code{as.data.table()} \tab \code{\link{as.data.table}} \cr
}
}

\examples{
 id = list("prob", "size")
 value = list(0.2, 5)
 support = list(Interval$new(0,1), PosNaturals$new())
 settable = list(TRUE, TRUE)
 description = list("Probability of success",NULL)
 ps = ParameterSet$new(id, value, support, settable,
                       description = description)
 ps$parameters()
 ps$getParameterValue("prob")
 ps$getParameterSupport("prob")


 id = list("rate", "scale")
 value = list(1, 1)
 support = list(PosReals$new(), PosReals$new())
 settable = list(TRUE, FALSE)
 updateFunc = list(NULL, function(self) 1/self$getParameterValue('rate'))
 description = list("Arrival rate","Scale parameter")
 ps = ParameterSet$new(id, value, support, settable,
                       updateFunc, description)
 ps$parameters(id = "rate")
 ps$setParameterValue(rate = 2) # Automatically calls $update
 ps$getParameterValue("scale") # Auto-updated to 1/2

}
\seealso{
\code{\link{Distribution}}
}
