% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneralisedExtremeValue.R
\name{quantile.GEV}
\alias{quantile.GEV}
\title{Determine quantiles of a GEV distribution}
\usage{
\method{quantile}{GEV}(x, probs, ...)
}
\arguments{
\item{x}{A \code{GEV} object created by a call to \code{\link[=GEV]{GEV()}}.}

\item{probs}{A vector of probabilities.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{probs}.
}
\description{
\code{quantile()} is the inverse of \code{cdf()}.
}
\examples{

set.seed(27)

X <- GEV(1, 2, 0.1)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
