% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{variance}
\alias{variance}
\alias{skewness}
\alias{kurtosis}
\title{Compute the moments of a probability distribution}
\usage{
variance(x, ...)

skewness(x, ...)

kurtosis(x, ...)
}
\arguments{
\item{x}{An object. The package provides methods for probability
distribution objects, e.g., those created by \code{\link[=Normal]{Normal()}} or \code{\link[=Beta]{Beta()}} etc.}

\item{...}{Further arguments passed to or from other methods. Unevaluated
arguments will generate a warning to catch mispellings or other possible
errors.}
}
\value{
A numeric scalar
}
\description{
The functions \code{variance}, \code{skewness}, and \code{kurtosis} are new
generic functions for computing moments of probability distributions such as
those provided in this package. Additionally, the probability distributions
from \pkg{distributions3} all have methods for the \code{\link[base]{mean}}
generic. Moreover, quantiles can be computed with methods for
\code{\link[stats]{quantile}}. For examples illustrating the usage with
probability distribution objects, see the manual pages of the respective
distributions, e.g., \code{\link{Normal}} or \code{\link{Binomial}} etc.
}
\seealso{
\code{\link[base]{mean}}, \code{\link[stats]{quantile}},
\code{\link{cdf}}, \code{\link{random}}
}
