% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streaklog.r
\name{streaklog}
\alias{streaklog}
\alias{whichmaxstreak}
\title{Utility functions for slicing gappy time series}
\usage{
streaklog(x)

whichmaxstreak(x, which = -1)
}
\arguments{
\item{x}{(\code{vector}) A vector with missing values.}

\item{which}{\code{(integer)} In case multiple streaks of the same length are found, which of them should be returned by the vector (integer).}
}
\description{
The function returns where the continuous streaks start and how long they are, which can be used for efficient and flexible subsetting.
}
\details{
The output list of \code{streaklog} contains the following elements:

\code{starts}: the indices where the streaks start.

\code{streaks}: the lengths of the individual streaks (number of values).

\code{runs}: the number of streaks.

The function whichmaxstreak() will return the indices of those values that are in the longest continuous streak.
}
\examples{
# generate a sequence of values
  b<-40:1
# add some gaps
  b[c(1:4, 15, 19, 23:27)]  <- NA
# the functions
  streaklog(b)
  whichmaxstreak(b)
}
