% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.accumulation.R
\name{autoplot.accumulation}
\alias{autoplot.accumulation}
\title{Plot Accumulation Objects}
\usage{
\method{autoplot}{accumulation}(
  object,
  ...,
  main = NULL,
  xlab = "Sample Size",
  ylab = NULL,
  shade_color = "grey75",
  alpha = 0.3,
  lty = ggplot2::GeomLine$default_aes$linetype,
  lwd = ggplot2::GeomLine$default_aes$linewidth
)
}
\arguments{
\item{object}{An object of class "accumulation".}

\item{...}{Unused.}

\item{main}{The main title of the plot.}

\item{xlab}{The label of the x-axis.}

\item{ylab}{The label of the y-axis.}

\item{shade_color}{The color of the shaded confidence envelopes.}

\item{alpha}{The opacity of the confidence envelopes, between 0 (transparent) and 1 (opaque).}

\item{lty}{The line type of the curves.}

\item{lwd}{The line width of the curves.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
Plot objects of class "accumulation" produced by \link{accum_hill} and other
accumulation functions.
}
\examples{
# Species accumulation curve
autoplot(accum_hill(mock_3sp_abd))

}
