% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{check_divent_args}
\alias{check_divent_args}
\title{check_divent_args}
\usage{
check_divent_args(
  abundances = NULL,
  alpha = NULL,
  as_numeric = NULL,
  check_arguments = NULL,
  coverage_estimator = NULL,
  distances = NULL,
  estimator = NULL,
  gamma = NULL,
  jack_alpha = NULL,
  jack_max = NULL,
  k = NULL,
  level = NULL,
  n_simulations = NULL,
  normalize = NULL,
  probability_estimator = NULL,
  q = NULL,
  rate = NULL,
  richness_estimator = NULL,
  sample_coverage = NULL,
  show_progress = NULL,
  similarities = NULL,
  species_distribution = NULL,
  tree = NULL,
  use.names = NULL,
  unveiling = NULL,
  weights = NULL
)
}
\arguments{
\item{abundances}{An object of class \link{abundances}.}

\item{alpha}{The risk level, 5\% by default.}

\item{as_numeric}{If \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{If \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{coverage_estimator}{An estimator of sample coverage used by \link{coverage}.}

\item{distances}{A distance matrix or an object of class \link[stats:dist]{stats::dist}}

\item{estimator}{An estimator of asymptotic entropy, diversity or richness.}

\item{gamma}{If \code{TRUE}, \eqn{\gamma} diversity, i.e. diversity of the metacommunity, is computed.}

\item{jack_alpha}{The risk level, 5\% by default, used to optimize the jackknife order.}

\item{jack_max}{The highest jackknife order allowed. Default is 10.}

\item{k}{The order of Hurlbert's diversity.}

\item{level}{The level of interpolation or extrapolation.
It may be a sample size (an integer) or a sample coverage
(a number between 0 and 1).
If not \code{NULL}, the asymptotic \code{estimator} is ignored.}

\item{n_simulations}{The number of simulations used to estimate the confidence envelope.}

\item{normalize}{If \code{TRUE}, phylogenetic is normalized: the height of the tree is set to 1.}

\item{probability_estimator}{A string containing one of the possible estimators
of the probability distribution (see \link{probabilities}).
Used only for extrapolation.}

\item{q}{The order of diversity.}

\item{rate}{The decay rate of the exponential similarity.}

\item{richness_estimator}{An estimator of richness to evaluate the total number of species,
see \link{div_richness}. Used for interpolation and extrapolation.}

\item{sample_coverage}{The sample coverage of \code{x} calculated elsewhere.
Used to calculate the gamma diversity of meta-communities, see details.}

\item{show_progress}{If TRUE, a progress bar is shown during long computations.}

\item{similarities}{A similarity matrix, that can be obtained by \link{fun_similarity}.
Its default value is the identity matrix.}

\item{species_distribution}{An object of class \link{species_distribution}.}

\item{tree}{An ultrametric, phylogenetic tree.
May be an object of class \link{phylo_divent}, \link[ape:read.tree]{ape::phylo}, \link[ade4:phylog]{ade4::phylog} or \link[stats:hclust]{stats::hclust}.}

\item{use.names}{if \code{TRUE}, the names of the \code{species_distribution} are kept
in the matrix or vector they are converted to.}

\item{unveiling}{A string containing one of the possible unveiling methods
to estimate the probabilities of the unobserved species (see \link{probabilities}).
Used only for extrapolation.}

\item{weights}{The weights of the sites of the species distributions.}
}
\value{
Returns \code{TRUE} or stops if a problem is detected.
}
\description{
Checks the arguments of a function of the package divent
}
\details{
The function compares the arguments passed to its parent function to the type
they should be and performs some extra tests, \emph{e.g.} probabilities must be positive and sum to 1.
It stops if an argument is not correct.

The function is always called without arguments.
Its arguments exist only for documentation.
}
\keyword{internal}
