% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ent_rao.R
\name{ent_rao}
\alias{ent_rao}
\alias{ent_rao.numeric}
\alias{ent_rao.species_distribution}
\title{Rao's Quadratic Entropy of a Community}
\usage{
ent_rao(x, ...)

\method{ent_rao}{numeric}(
  x,
  distances = NULL,
  tree = NULL,
  normalize = TRUE,
  estimator = c("Lande", "naive"),
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)

\method{ent_rao}{species_distribution}(
  x,
  distances = NULL,
  tree = NULL,
  normalize = TRUE,
  estimator = c("Lande", "naive"),
  gamma = FALSE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object, that may be a numeric vector containing abundances or probabilities,
or an object of class \link{abundances} or \link{probabilities}.}

\item{...}{Unused.}

\item{distances}{A distance matrix or an object of class \link[stats:dist]{stats::dist}}

\item{tree}{An ultrametric, phylogenetic tree.
May be an object of class \link{phylo_divent}, \link[ape:read.tree]{ape::phylo}, \link[ade4:phylog]{ade4::phylog} or \link[stats:hclust]{stats::hclust}.}

\item{normalize}{If \code{TRUE}, phylogenetic is normalized: the height of the tree is set to 1.}

\item{estimator}{An estimator of entropy.}

\item{as_numeric}{If \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{If \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{gamma}{If \code{TRUE}, \eqn{\gamma} diversity, i.e. diversity of the metacommunity, is computed.}
}
\value{
A tibble with the site names, the estimators used and the estimated entropy.
}
\description{
Estimate the quadratic entropy \insertCite{Rao1982}{divent} of species from
abundance or probability data.
An estimator \insertCite{Lande1996}{divent} is available to deal with
incomplete sampling.
}
\details{
Rao's entropy is phylogenetic or similarity-based entropy of order 2.
\link{ent_phylo} and \link{ent_similarity} with argument \code{q = 2} provide more estimators
and allow estimating entropy at a chosen level.

All species of the \code{species_distribution} must be found in the matrix of
\code{distances} if it is named.
If it is not or if \code{x} is numeric, its size must equal the number of species.
Then, the order of species is assumed to be the same as that of the
\code{species_distribution} or its numeric equivalent.
}
\examples{
# Entropy of each community
ent_rao(paracou_6_abd, tree = paracou_6_taxo)
# Similar to (but estimators are not the same) 
ent_phylo(paracou_6_abd, tree = paracou_6_taxo, q = 2)

# Functional entropy
ent_rao(paracou_6_abd, distances = paracou_6_fundist)

# gamma entropy
ent_rao(paracou_6_abd, tree = paracou_6_taxo, gamma = TRUE)

}
\references{
\insertAllCited{}
}
