% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pantheon}
\alias{pantheon}
\title{Pantheon dataset}
\format{A dataframe with variables:
\describe{
\item{Country}{Name of the country}
\item{Occupation}{Occupation according to Pantheon's taxonomy}
\item{Value}{Quantity of globally known that waws born in that country}
}}
\source{
\url{http://pantheon.media.mit.edu/}
}
\usage{
pantheon
}
\description{
Dataframe of globally known people according to MIT's Pantheon 1.0.
Dataset includes number of globally known people for a \strong{sample}
of 10 countries and 53 different occupations.
The \strong{complete} dataset is described in [Yu et al., 2015].
}
\examples{
data(pantheon)
str(pantheon)
summary(pantheon)
pantheon[pantheon$Country=="Chile",]
}
\references{
A. Z. Yu, S. Ronen, K. Hu, T. Lu, and C. A. Hidalgo, 'Pantheon: A Dataset for the Study of Global Cultural Production', arXiv:1502.07310 [physics], Feb. 2015.
}
\keyword{dataset}

