% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap.R
\name{overlap}
\alias{overlap}
\alias{across}
\alias{chain}
\alias{aligns_start}
\alias{aligns_end}
\alias{inbetween}
\alias{overlap_method}
\title{Overlapping number line objects}
\usage{
overlap(x, y, method = c("across", "chain", "aligns_start", "aligns_end",
  "inbetween"))

across(x, y)

chain(x, y)

aligns_start(x, y)

aligns_end(x, y)

inbetween(x, y)

overlap_method(x, y)
}
\arguments{
\item{x}{\code{number_line} object}

\item{y}{\code{number_line} object}

\item{method}{Method of overlap}
}
\value{
\code{logical} object

\code{character} object
}
\description{
A set of functions to identify overlapping \code{number_line} objects
}
\examples{
a <- number_line(-100, 100)
b <- number_line(10, 11.2)
c <- number_line(100, 200)
d <- number_line(100, 120)
e <- number_line(50, 120)
g <- number_line(100,100)
across(a, b)
across(a, e)
chain(c, d)
chain(a, c)
aligns_start(c, d)
aligns_start(a, c)
aligns_end(d, e)
aligns_end(a, c)
inbetween(a, g)
inbetween(b, a)
overlap_method(a, c)
overlap_method(d, c)
overlap_method(a, g)
overlap_method(b, e)
}
