% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/episodes.R
\name{episodes_wf_splits}
\alias{episodes_wf_splits}
\title{Track episodes in a reduced dataset.}
\usage{
episodes_wf_splits(..., duplicates_recovered = "ANY", reframe = FALSE)
}
\arguments{
\item{...}{Arguments passed to \code{\link{episodes}}.}

\item{duplicates_recovered}{\code{[character]}. Determines which duplicate records are recycled.
Options are \code{"ANY"} (default), \code{"without_sub_criteria"} or \code{"with_sub_criteria"}. See \code{Details}.}

\item{reframe}{\code{[logical]}. Determines if the duplicate records in a \code{\link{sub_criteria}} are reframed (\code{TRUE}) or excluded (\code{FALSE}).}
}
\value{
\code{\link[=epid-class]{epid}}; \code{list}
}
\description{
Excludes duplicate records from the same day or period prior before passing the analysis to \code{\link{episodes}}.
Only duplicate records that will not affect the case definition are excluded.
The resulting episode identifiers are recycled for the duplicate records.
}
\details{
\bold{\code{episodes_wf_splits()}} is a wrapper function of \bold{\code{episodes()}} which reduces or re-frames the dataset to
the minimum number of records required to implement a case definition.
This leads to the same outcome but with the benefit of a shorter processing time.

Duplicate records from the same point or period in time are excluded from \bold{\code{episodes()}}.
The resulting \code{\link[=epid-class]{epid}} object is then recycled for the duplicates.

The \code{duplicates_recovered} argument determines which identifiers are recycled.
If \code{"without_sub_criteria"} is selected, only identifiers created from a matched \code{\link{sub_criteria}} (\code{"Case_CR"} and \code{"Recurrent_CR"}) are recycled.
The opposite (\code{"Case"} and \code{"Recurrent"}) is the case if \code{"with_sub_criteria"} is selected.
Excluded duplicates of \code{"Duplicate_C"} and \code{"Duplicate_R"} are always recycled.

The \code{reframe} argument will either \code{\link{reframe}} or subset a \code{\link{sub_criteria}}.
Both will require slightly different functions for \code{match_funcs} or \code{equal_funcs}.
}
\examples{
# With 10,000 duplicate records of 20 events,
# `episodes_wf_splits()` will take less time than `episodes()`
dates <- seq(from = as.Date("2019-04-01"), to = as.Date("2019-04-20"), by = 1)
dates <- rep(dates, 10000)

system.time(
  ep1 <- episodes(dates, 1)
)
system.time(
  ep2 <- episodes_wf_splits(dates, 1)
)

# Both leads to the same outcome.
all(ep1 == ep2)
}
\seealso{
\code{\link{episodes}}; \code{\link{sub_criteria}}
}
