% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discribe.R
\name{describe}
\alias{describe}
\alias{describe.data.frame}
\alias{describe.grouped_df}
\title{Compute descriptive statistic}
\usage{
describe(.data, ...)

\method{describe}{data.frame}(.data, ...)

\method{describe}{grouped_df}(.data, ...)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}} or a \code{\link{grouped_df}}.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, describe() will automatically start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.

See vignette("EDA") for an introduction to these concepts.}
}
\value{
An object of the same class as .data.
}
\description{
The describe() compute descriptive statistic of numeric
variable for exploratory data analysis.
}
\details{
This function is useful when used with the \code{\link{group_by}} function
of the dplyr package.
If you want to calculate the statistic by level of the categorical data
you are interested in, rather than the whole statistic, you can use
grouped_df as the group_by() function.
}
\section{Descriptive statistic information}{

The information derived from the numerical data describe is as follows.

\itemize{
\item n : number of observations excluding missing values
\item na : number of missing values
\item mean : arithmetic average
\item sd : standard deviation
\item se_mean : standard error mean. sd/sqrt(n)
\item IQR : interquartile range (Q3-Q1)
\item skewness : skewness
\item kurtosis : kurtosis
\item p25 : Q1. 25\% percentile
\item p50 : median. 50\% percentile
\item p75 : Q3. 75\% percentile
\item p01, p05, p10, p20, p30 : 1\%, 5\%, 20\%, 30\% percentiles
\item p40, p60, p70, p80 : 40\%, 60\%, 70\%, 80\% percentiles
\item p90, p95, p99, p100 : 90\%, 95\%, 99\%, 100\% percentiles

}
}

\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Describe descriptive statistics of numerical variables
describe(carseats)

# Select the variable to describe
describe(carseats, Sales, Price)
describe(carseats, -Sales, -Price)
describe(carseats, 5)

# Using dplyr::grouped_dt
library(dplyr)

gdata <- group_by(carseats, ShelveLoc, US)
describe(gdata, "Income")

# Using pipes ---------------------------------
# Positive values select variables
carseats \%>\%
 describe(Sales, CompPrice, Income)

# Negative values to drop variables
carseats \%>\%
 describe(-Sales, -CompPrice, -Income)

# Using pipes & dplyr -------------------------
# Find the statistic of all numerical variables by 'ShelveLoc' and 'US',
# and extract only those with 'ShelveLoc' variable level is "Good".
carseats \%>\%
 group_by(ShelveLoc, US) \%>\%
   describe() \%>\%
   filter(ShelveLoc == "Good")

# extract only those with 'Urban' variable level is "Yes",
# and find 'Sales' statistics by 'ShelveLoc' and 'US'
carseats \%>\%
 filter(Urban == "Yes") \%>\%
 group_by(ShelveLoc, US) \%>\%
 describe(Sales)
}
\seealso{
\code{\link{describe.tbl_dbi}}, \code{\link{diagnose_numeric.data.frame}}.
}
