% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation.R
\name{plot.imputation}
\alias{plot.imputation}
\title{Visualize Information for an "imputation" Object}
\usage{
\method{plot}{imputation}(x, typographic = TRUE, ...)
}
\arguments{
\item{x}{an object of class "imputation", usually, a result of a call to imputate_na()
or imputate_outlier().}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{...}{arguments to be passed to methods, such as graphical parameters (see par).
only applies when the model argument is TRUE, and is used for ... of the plot.lm() function.}
}
\description{
Visualize two kinds of plot by attribute of `imputation` class.
The imputation of a numerical variable is a density plot,
and the imputation of a categorical variable is a bar plot.
}
\examples{
\donttest{
# Generate data for the example
heartfailure2 <- heartfailure
heartfailure2[sample(seq(NROW(heartfailure2)), 20), "platelets"] <- NA
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "smoking"] <- NA

# Impute missing values -----------------------------
# If the variable of interest is a numerical variables
platelets <- imputate_na(heartfailure2, platelets, death_event, method = "rpart")
platelets
summary(platelets)

plot(platelets)

# If the variable of interest is a categorical variables
smoking <- imputate_na(heartfailure2, smoking, death_event, method = "mice")
smoking
summary(smoking)

plot(smoking)

# Impute outliers ----------------------------------
# If the variable of interest is a numerical variable
platelets <- imputate_outlier(heartfailure2, platelets, method = "capping")
platelets
summary(platelets)

plot(platelets)
}
}
\seealso{
\code{\link{imputate_na}}, \code{\link{imputate_outlier}}, \code{\link{summary.imputation}}.
}
