% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate.R
\name{summary.correlate}
\alias{summary.correlate}
\title{Summarizing Correlation Coefficient}
\usage{
\method{summary}{correlate}(object, ...)
}
\arguments{
\item{object}{an object of class "correlate", usually, a result of a call 
to correlate().}

\item{...}{further arguments passed to or from other methods.}
}
\description{
summary method for "correlate" class.
}
\details{
summary.correlate compares the correlation coefficient by variables.
}
\examples{
\donttest{
library(dplyr)

# Correlation type is "generic" ===============================
# Correlation coefficients of all numerical variables
corr_tab <- correlate(heartfailure)
corr_tab

# summary correlate class 
mat <- summary(corr_tab)
mat

# Select the variable to compute
corr_tab <- correlate(heartfailure, creatinine, sodium)
corr_tab

# summary correlate class 
mat <- summary(corr_tab)
mat

# Correlation type is "group" ===============================
##-----------------------------------------------------------
# If the target variable is a categorical variable
# Using dplyr
corr_tab <- heartfailure \%>\%
  group_by(smoking, death_event) \%>\% 
  correlate() 

corr_tab

# summary correlate class 
mat <- summary(corr_tab)
mat

corr_tab <- heartfailure \%>\%
  group_by(smoking, death_event) \%>\% 
  correlate(creatinine) \%>\% 
  filter(abs(coef_corr) >= 0.2)

corr_tab

# summary correlate class 
mat <- summary(corr_tab)
mat
}

}
\seealso{
\code{\link{correlate}}, \code{\link{plot.correlate}}.
}
