% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{maybe_process}
\alias{maybe_process}
\title{Process a File if Necessary}
\usage{
maybe_process(
  source_path,
  target_path,
  process_f = readRDS,
  process_args = NULL,
  write_f = saveRDS,
  write_args = NULL,
  force_process = FALSE
)
}
\arguments{
\item{source_path}{Character scalar; the path to the raw file. Paths starting
with \code{http://}, \code{http://}, \code{http://}, or \code{http://} will
be downloaded to a temp file if the processed version is not already
available.}

\item{target_path}{Character scalar; the path where the processed version of
the file should be stored.}

\item{process_f}{A function or one-sided formula to use to process the source
file. \code{source_path} will be passed as the first argument to this
function. Defaults to \code{read_f}.}

\item{process_args}{An optional list of additional arguments to
\code{process_f}.}

\item{write_f}{A function or one-sided formula to use to save the processed
file. The processed object will be passed as the first argument to this
function, and \code{target_path} will be passed as the second argument.
Defaults to \code{\link[base]{saveRDS}}.}

\item{write_args}{An optional list of additional arguments to \code{write_f}.}

\item{force_process}{A logical scalar indicating whether we should process
the source file even if the target already exists. This can be particularly
useful if you wish to redownload a file.}
}
\value{
The normalized \code{target_path}.
}
\description{
Sometimes you just need to get a processed file to a particular location,
without reading the data. For example, you might need to download a lookup
table used by various functions in a package, independent of a particular
function call that needs the data. This function does the processing if it
hasn't already been done.
}
\examples{
if (interactive()) {
  temp_filename <- tempfile()
  maybe_process(
    "https://query.data.world/s/owqxojjiphaypjmlxldsp566lck7co",
    target_path = temp_filename,
    process_f = read.csv
  )

  unlink(temp_filename)
}
}
