% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm.R
\name{tbl.dm}
\alias{tbl.dm}
\alias{compute.dm}
\alias{compute.zoomed_dm}
\alias{src_tbls.dm}
\alias{copy_to.dm}
\alias{collect.dm}
\title{\pkg{dplyr} table retrieval, table info and DB interaction methods}
\usage{
\method{tbl}{dm}(src, from, ...)

\method{compute}{dm}(x, ...)

\method{compute}{zoomed_dm}(x, ...)

\method{src_tbls}{dm}(x, ...)

\method{copy_to}{dm}(
  dest,
  df,
  name = deparse(substitute(df)),
  overwrite = FALSE,
  temporary = TRUE,
  repair = "unique",
  quiet = FALSE,
  ...
)

\method{collect}{dm}(x, ...)
}
\arguments{
\item{src}{A \code{dm} object.}

\item{from}{A length one character variable containing the name of the requested table}

\item{...}{See original function documentation}

\item{x}{Either a \code{dm} or a \code{zoomed_dm}; the latter leads to an error for \code{src_tbls.dm()}}

\item{dest}{For \code{copy_to.dm()}: The \code{dm} object to which a table should be copied.}

\item{df}{For \code{copy_to.dm()}: A table (can be on a different \code{src})}

\item{name}{For \code{copy_to.dm()}: See \code{\link[dplyr:copy_to]{dplyr::copy_to}}}

\item{overwrite}{For \code{copy_to.dm()}: See \code{\link[dplyr:copy_to]{dplyr::copy_to}}; \code{TRUE} leads to an error}

\item{temporary}{For \code{copy_to.dm()}: If the \code{dm} is on a DB, the copied version of \code{df} will only be written temporarily to the DB.
After the connection is reset it will no longer be available.}

\item{repair, quiet}{Name repair options; cf. \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names}}}
}
\description{
Use these methods without the '.dm' or '.zoomed_dm' suffix (see examples).
}
