% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten.R
\name{dm_flatten_to_tbl}
\alias{dm_flatten_to_tbl}
\alias{dm_squash_to_tbl}
\title{Flatten a part of a \code{dm} into a wide table}
\usage{
dm_flatten_to_tbl(dm, start, ..., join = left_join)

dm_squash_to_tbl(dm, start, ..., join = left_join)
}
\arguments{
\item{dm}{A \code{\link{dm}} object.}

\item{start}{The table from which all outgoing foreign key relations are considered
when establishing a processing order for the joins.
An interesting choice could be
for example a fact table in a star schema.}

\item{...}{Unquoted names of the tables to be included in addition to the \code{start} table.
The order of the tables here determines
the order of the joins.
If the argument is empty, all tables that can be reached will be included.
If this includes tables that are not direct neighbors of \code{start},
it will only work with \code{dm_squash_to_tbl()} (given one of the allowed join-methods).
\code{tidyselect} is supported, see \code{\link[dplyr:select]{dplyr::select()}} for details on the semantics.}

\item{join}{The type of join to be performed, see \code{\link[dplyr:join]{dplyr::join()}}.}
}
\value{
A single table that results from consecutively joining all affected tables to the \code{start} table.
}
\description{
\code{dm_flatten_to_tbl()} and \code{dm_squash_to_tbl()} gather all information of interest in one place in a wide table.
Both functions perform a disambiguation of column names and a cascade of joins.
}
\details{
With \code{...} left empty, this function will join together all the tables of your \code{\link{dm}}
object that can be reached from the \code{start} table, in the direction of the foreign key relations
(pointing from the child tables to the parent tables), using the foreign key relations to
determine the argument \code{by} for the necessary joins.
The result is one table with unique column names.
Use the \code{...} argument if you would like to control which tables should be joined to the \code{start} table.

How does filtering affect the result?

\strong{Case 1}, either no filter conditions are set in the \code{dm}, or set only in the part that is unconnected to the \code{start} table:
The necessary disambiguations of the column names are performed first.
Then all involved foreign tables are joined to the \code{start} table successively, with the join function given in the \code{join} argument.

\strong{Case 2}, filter conditions are set for at least one table that is connected to \code{start}:
First, disambiguation will be performed if necessary. The \code{start} table is then calculated using \code{tbl(dm, "start")}.
This implies
that the effect of the filters on this table is taken into account.
For \code{right_join}, \code{full_join} and \code{nest_join}, an error
is thrown if any filters are set because filters will not affect the right hand side tables and the result will therefore be
incorrect in general (calculating the effects on all RHS-tables would also be time-consuming, and is not supported;
if desired, call \code{dm_apply_filters()} first to achieve that effect).
For all other join types, filtering only the \code{start} table is enough because the effect is passed on by
successive joins.

Mind that calling \code{dm_flatten_to_tbl()} with \code{join = right_join} and no table order determined in the \code{...} argument
will not lead to a well-defined result if two or more foreign tables are to be joined to \code{start}.
The resulting
table would depend on the order the tables that are listed in the \code{dm}.
Therefore, trying this will result in a warning.

Since \code{join = nest_join()} does not make sense in this direction (LHS = child table, RHS = parent table: for valid key constraints
each nested column entry would be a tibble of one row), an error will be thrown if this method is chosen.
}
\examples{
dm_nycflights13() \%>\%
  dm_select_tbl(-weather) \%>\%
  dm_flatten_to_tbl(flights)
}
\seealso{
Other flattening functions: 
\code{\link{dm_join_to_tbl}()}
}
\concept{flattening functions}
